#include "GetPoint.js"

function DoPolygon()
{
	var polygonfactory = moi.command.createFactory( 'polygonstar' );

	var ui = moi.ui;
	ui.bindUIToInput( 'numsidesinput', 'value', polygonfactory.getInput(2) );

	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return;

	polygonfactory.setInput( 0, pointpicker.ptframe );

	ui.beginUIUpdate();
	ui.hideUI( 'CenterPrompt' );
	ui.showUI( 'FirstRadiusPrompt' );
	ui.endUIUpdate();

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, true );
	pointpicker.stickToSurfacesMode = 'max';
	pointpicker.disableVerticalStraightSnap = true;

	pointpicker.bindResultPt( polygonfactory.getInput(1) );
	pointpicker.bindResultOrientation( polygonfactory.getInput(0) );

	if ( !GetPoint( pointpicker ) )
		return;
		
	// If style = custom, then allow another pick to define the second radius.
	if ( ui.commandUI.starstyle.value == 'Custom' )
	{
		ui.beginUIUpdate();
		ui.hideUI( 'FirstRadiusPrompt' );
		ui.hideUI( 'starstyletr' );
		ui.showUI( 'SecondRadiusPrompt' );
		ui.endUIUpdate();
	
		pointpicker.reset();
		pointpicker.restrictToPlane( polygonfactory.getInput(0).getValue(), true );
		pointpicker.disableVerticalStraightSnap = true;		
		pointpicker.bindResultPt( polygonfactory.getInput(3) );
		
		if ( !GetPoint( pointpicker ) )
			return;
	}
	
	polygonfactory.commit();
}

DoPolygon();
